package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.OrderBO;
import com.bizvane.members.feign.model.bo.OrderListRequestParam;
import com.bizvane.members.feign.model.vo.OrderDetailVO;
import com.bizvane.members.feign.model.vo.OrderVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/order")
@Api("订单管理")
public interface OrderFeign {

  @ApiOperation(value = "新增订单", notes = "新增订单", tags = {"新增订单接口"},httpMethod = "POST")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<Boolean> add(@RequestBody @Valid  OrderBO orderBO);

  @ApiOperation(value = "查询订单列表", notes = "查询订单列表", tags = {"查询订单列表接口"},httpMethod = "POST")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<OrderVO>> list(@RequestBody OrderListRequestParam param);

  @ApiOperation(value = "新增订单详情", notes = "新增订单详情", tags = {"新增订单详情接口"},httpMethod = "POST")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<OrderDetailVO> detail(@RequestParam("mbrOrderCode") @NotNull String mbrOrderCode);
}
