package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class OrderListRequestParam {

    @ApiModelProperty("订单code")
    private String mbrOrderCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("订单类型：1-商户订单，2-停车订单，3-酒店订单，4-贵宾服务，5-机场管家")
    private Integer orderType;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("排除订单号")
    private List<String> excludeOrderNoList;

    @ApiModelProperty("订单状态：1-待付款, 2-待发货, 3-已发货, 4-已签收, 5-交易成功, 6-退款中, 7-退款成功, 8-交易关闭")
    private Integer orderStatus;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("下单时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime placeOrderStart;

    @ApiModelProperty("下单时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime placeOrderEnd;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime placeOrderTime;

    @ApiModelProperty("支付金额")
    private BigDecimal payMoneyMin;

    @ApiModelProperty("订单标志 0退单订单标志不通过此字段判断 1是订单2是退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    private int pageNum = 1;

    private int pageSize  = 10;
}
