package com.bizvane.members.feign.model.mq;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class CouponUseMQ implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券使用订单金额")
    private BigDecimal useBusinessAmount;

    @ApiModelProperty("使用时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime useTime;

    @ApiModelProperty("券编号")
    private String couponDefinitionCode;
}
