package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityAvailableListReq {

    @NotBlank
    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @NotBlank
    @ApiModelProperty("商户编号")
    private String merchantNo;

    @NotEmpty
    @ApiModelProperty("sku编码")
    private List<String> skuNoList;

    @NotNull
    @ApiModelProperty("订单金额")
    private BigDecimal orderAmount;

    @NotNull
    @ApiModelProperty("订单原价")
    private BigDecimal orderTagPrice;

    private int pageNum = 1;

    private int pageSize  = 10;

}
