package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class BasicFlightFocusQueryReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotBlank
    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("航班号全称")
    private String flightIdentity;

    @ApiModelProperty("航班日期yyyy-MM-dd")
    private String flightDate;

    @ApiModelProperty("始发机场 IATA")
    private String iataOriginAirport;

    @ApiModelProperty("目的机场 IATA")
    private String destinationAirport;
}
