package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.BasicAerodromeListReq;
import com.bizvane.members.feign.model.bo.BasicFlightFocusQueryReq;
import com.bizvane.members.feign.model.bo.BasicFlightQueryReq;
import com.bizvane.members.feign.model.bo.BasicFlightSaveReq;
import com.bizvane.members.feign.model.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/basicFlight")
@Api("航班信息管理")
public interface BasicFlightFeign {

  @ApiOperation(value = "新增航班", notes = "新增航班", tags = {"新增航班"},httpMethod = "POST")
  @RequestMapping(value="/save", method = RequestMethod.POST)
  ResponseData<String> save(@RequestBody @Valid BasicFlightSaveReq req);

  @ApiOperation(value = "查询航班列表", notes = "查询航班列表", tags = {"查询航班列表"},httpMethod = "POST")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<List<BasicFlightQueryRsp>> list(@RequestBody @Valid BasicFlightQueryReq bo);

  @ApiOperation(value = "关注航班-查询航班列表", notes = "关注航班-查询航班列表", tags = {"关注航班-查询航班列表"},httpMethod = "POST")
  @RequestMapping(value="/listFocusQuery", method = RequestMethod.POST)
  ResponseData<List<BasicFlightFocusQueryRsp>> listFocusQuery(@RequestBody @Valid BasicFlightFocusQueryReq bo);

  @ApiOperation(value = "航班出行提醒", notes = "航班出行提醒", tags = {"航班出行提醒"},httpMethod = "POST")
  @RequestMapping(value="/travelMsg", method = RequestMethod.POST)
  ResponseData<Object> travelMsg();

  @ApiOperation(value = "获取通航点列表", notes = "获取通航点列表", tags = {"获取通航点列表"},httpMethod = "POST")
  @RequestMapping(value="/listAerodrome", method = RequestMethod.POST)
  ResponseData<List<BasicAerodromeVO>> listAerodrome(@RequestBody BasicAerodromeListReq bo);

  @ApiOperation(value = "详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  ResponseData<BasicFlightDetailRsp> detail(@RequestParam("basicFlightCode") String basicFlightCode);
}
