package com.bizvane.members.feign.model.mq;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrOrderAddMQ {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty(value = "订单code")
    private String mbrOrderCode;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单类型：1-商户订单，2-停车订单，3-酒店订单，4-贵宾服务，5-机场管家")
    private Integer orderType;

    @ApiModelProperty("排除消费标签")
    private Boolean excludeConsumerLabel;

    @ApiModelProperty("订单标志：1-订单，2-退单")
    private Integer orderFlag;

    @ApiModelProperty("原始订单code")
    private String originalMbrOrderCode;

    @ApiModelProperty("原始订单号")
    private String originalOrderNo;

    @ApiModelProperty("原始订单下单时间")
    private LocalDateTime originalPlaceOrderTime;

    @ApiModelProperty("订单金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty("商品数量")
    private Integer productCount;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime placeOrderTime;

    @ApiModelProperty("支付时间 ")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime payTime;

    @ApiModelProperty("支付金额")
    private BigDecimal payMoney;

    @ApiModelProperty(value = "订单折扣")
    private BigDecimal discount;

    @ApiModelProperty("机场编号")
    private String airportNo;

    @ApiModelProperty("行业")
    private String industryNo;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("是否首单：true首单")
    private boolean isFirst;

    @ApiModelProperty(value = "消费渠道")
    private String channelCode;

    @ApiModelProperty(value = "消费来源")
    private String sourceCode;
}
