package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class FlightRecordListRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("航班状态：1-待出行, 5-飞行中, 10-已取消, 15-已完成")
    private List<Integer> flightStatusList;

    private Integer focusStatus;

    private String flightDate;

    @ApiModelProperty("航班日期开始")
    private String flightDateStart;

    @ApiModelProperty("航班日期结束")
    private String flightDateEnd;

    @ApiModelProperty("航空公司(承运人)二字码")
    private String airlineIataCode;

    @ApiModelProperty("航班号")
    private String flightIdentity;

    private String mbrFlightRecordCode;

    @ApiModelProperty("身份证号")
    private String idCardNumber;

    private String seatNo;

    @ApiModelProperty("FlightDirection 和 FlightRoute 至少必填一项，A - 到港，D - 离港")
    private String flightDirection;

    @ApiModelProperty("验证状态 0-验证放行：旅客进隔离区，1-验证退回，2-移交公安，3-退出隔离区：旅客出隔离区，4-未验证，5-移交上级处理结果：放行，6-移交上级处理结果：照顾放行，7-移交上级处理结果：移交公安，8-移交上级处理结果：退回")
    private List<Integer> psgResultList;

    private int pageNum = 1;

    private int pageSize  = 10;
}
