package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityInvalidRequestParam {

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券code")
    private String couponCode;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人人")
    private String userName;

    @ApiModelProperty(value = "作废商户编码", example = "merchantNo123456789", required = true)
    private String invalidMerchantCode;

    @ApiModelProperty(value = "作废渠道Code, 10=微信渠道, 20=线下渠道 30=东航云平台", example = "10", required = true)
    private String invalidChannelCode;

    @ApiModelProperty(value = "作废来源Code, 10=爱上启航小程序, 20=上海机场小程序, 30=浦东机场小程序, 40=缤纷品购小程序, 50=上海机场贵宾线上VIP小程序, 60=虹桥机场交通小程序, 70=浦东机场商业POS, 80=虹桥机场商业POS, 90=东航云平台航延系统", required = true)
    private String invalidSourceCode;
}
