package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.CouponExternalRecordVO;
import com.bizvane.members.feign.model.vo.CouponExternalSumVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/couponExternal")
@Api("外部券管理")
public interface CouponExternalFeign {

  @ApiOperation(value = "新增外部券汇总")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody CouponExternalSumRequestParam param);

  @ApiOperation(value = "新增外部券明细")
  @RequestMapping(value="/addRecord", method = RequestMethod.POST)
  ResponseData<String> addRecord(@RequestBody CouponExternalRecordAddRequestParam param);

  @ApiOperation(value = "更新状态")
  @RequestMapping(value="/updateStatus", method = RequestMethod.POST)
  ResponseData<Boolean> updateStatus(@RequestBody CouponExternalUpdateStatusRequestParam param);

  @ApiOperation(value = "查询外部券汇总列表")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  ResponseData<PageInfo<CouponExternalSumVO>> list(@RequestBody CouponExternalSumListRequestParam param);

  @ApiOperation(value = "查询外部券明细列表")
  @RequestMapping(value="/listRecord", method = RequestMethod.POST)
  ResponseData<PageInfo<CouponExternalRecordVO>> listRecord(@RequestBody CouponExternalRecordListRequestParam param);
}