package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class MbrLicensePlateVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("车牌数据code")
    private String mbrLicensePlateCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("车牌类型：1-燃油车牌，2-新能源车牌")
    private Integer type;

    @ApiModelProperty("车牌号")
    private String licensePlate;

    @ApiModelProperty("默认车牌：true-默认，false-非默认")
    private Boolean isDefault;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;
}
