package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponCalculateDiscountAmountVO {

    @NotBlank
    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券状态：11-失败，20-未使用，25-已过期，30-已核销，35-已作废")
    private Integer couponStatus;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("描述")
    private String info;

    @NotNull
    @ApiModelProperty("优惠金额")
    private BigDecimal discountPrice;
}
