package com.bizvane.members.feign.model.mq;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrRegisterMQ {

    @ApiModelProperty(value = "会员编号")
    private String mbrMembersCode;

    @ApiModelProperty(value = "会员卡号")
    private String cardNo;

    @ApiModelProperty("脱敏手机号")
    private String phone;

    @ApiModelProperty("手机号加密")
    private String phoneEncrypt;

    @ApiModelProperty("微信unioinid")
    private String unionId;

    @ApiModelProperty(value = "会员姓名")
    private String name;

    @ApiModelProperty("开卡时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime openCardTime;

    @ApiModelProperty("会员生日")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime birthday;

    @ApiModelProperty("会员性别,女:1 男:2 未知:3")
    private String gender;

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("来源code取自SourceEnum枚举表")
    private String sourceCode;

    @ApiModelProperty("注册机场code")
    private String airportCode;

    @ApiModelProperty("注册机场明细code")
    private String airportDetailCode;

    @ApiModelProperty("注册详情类型：1-楼宇，2-商户，3-渠道码")
    private Integer detailType;

    @ApiModelProperty("注册详情code")
    private String detailCode;

    @ApiModelProperty(value = "开卡链路traceCode")
    private String traceCode;
}
