package com.bizvane.members.feign.model.mq;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrLevelUpgradeMQ {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员姓名")
    private String name;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("原等级code")
    private String originMbrLevelDefCode;

    @ApiModelProperty("操作类型：1-升级，2-降级")
    private Integer opsType;

    @ApiModelProperty("变动时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDate;

}
