package com.bizvane.members.feign.model.mq;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class CouponExpirationMQ implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("过期时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime expirationTime;
}
