package com.bizvane.members.facade.models.qywx;

import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * 区经门店客户资产排产榜 请求Vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月27日 14:01:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AreaManagerAssetsRankReqVo {

    /**
     * 资产类型 1会员 2粉丝 3好友
     */
    @NotEmpty
    @ApiModelProperty(name = "assetsType", value = "资产类型 1会员 2粉丝 3好友")
    private String assetsType;

    /**
     * 查询类型 1 门店资产 2 导购资产
     */
    @NotEmpty
    @ApiModelProperty(name = "queryType",value = "查询类型 1 门店资产 2 导购资产")
    private String queryType;

    /**
     * 区域下 全部店铺idList
     */
    @ApiModelProperty(name = "storeIdList",value = "区域下 全部店铺idList")
    private List<Long> storeIdList;

    @ApiModelProperty(name = "sysOfflineStoreCodeList",value = "区域下 全部店铺Code List")
    private List<String> sysOfflineStoreCodeList;

    /**
     * 模糊查询店铺idList
     */
    @ApiModelProperty(name = "fuzzyQueryStoreIdList",value = "模糊查询店铺idList")
    private List<Long> fuzzyQueryStoreIdList;

    /**
     * 区域下 全部导购idList
     */
    @ApiModelProperty(name = "staffIdList",value = "区域下 全部导购idList")
    private List<Long> staffIdList;

    @ApiModelProperty(name = "staffCodeList",value = "区域下 全部导购Code List")
    private List<String> staffCodeList;

    /**
     * 模糊查询导购idList
     */
    @ApiModelProperty(name = "fuzzyQueryStaffIdList",value = "模糊查询导购idList")
    private List<Long> fuzzyQueryStaffIdList;

    /**
     * 页数
     */
//    @NotNull
    @ApiModelProperty(name = "pageNum",value = "页数")
    private Integer pageNum;

    /**
     * 单页数量
     */
//    @NotNull
    @ApiModelProperty(name = "pageSize",value = "单页数量")
    private Integer pageSize;

    /**
     * sysCompanyId
     */
    @NotNull
    private Long sysCompanyId;

    /**
     * brandId
     */
    private Long brandId;

    @ApiModelProperty(name = "startTime",value = "开始时间")
    private Date startTime;

    @ApiModelProperty(name = "endTime",value = "结束时间")
    private Date endTime;

    @ApiModelProperty(name = "isIncrement",value = "是否查询增量会员资产 true-是 false-否")
    private Boolean isIncrement;


}
