package com.bizvane.members.facade.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/24 09:14
 * @Description:订单评价
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_order_evaluate")
public class OrderEvaluateModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = -3520231760075808796L;

    @Id
    @ApiModelProperty(value = "订单评价主键", name = "mbrOrderEvaluateId", example = "订单评价主键")
    private Long mbrOrderEvaluateId;

    @ApiModelProperty(value = "企业id", name = "brandId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "所属订单", name = "orderNo", example = "所属订单")
    private String orderNo;

    @ApiModelProperty(value = "商品评均分", name = "productScore", example = "商品评均分")
    private Double productScore;

    @ApiModelProperty(value = "店铺环境评分（最高5分）", name = "storeEnvironmentGrade", example = "店铺环境评分（最高5分）")
    private Integer storeEnvironmentGrade;

    @ApiModelProperty(value = "店铺服务评分（最高5分）", name = "storeServerGrade", example = "店铺服务评分（最高5分）")
    private Integer storeServerGrade;

    @ApiModelProperty(value = "评价时间", name = "evaluateTime", example = "评价时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date evaluateTime;

    @ApiModelProperty(value = "店铺名称", name = "storeName", example = "店铺名称")
    private String storeName;

    @ApiModelProperty(value = "服务导购名称", name = "guideName", example = "服务导购名称")
    private String guideName;

    @ApiModelProperty(value = "店铺id", name = "storeId", example = "店铺id")
    private Integer storeId;

    @ApiModelProperty(value = "店铺code", name = "storeCode", example = "店铺code")
    private String storeCode;

    @ApiModelProperty(value = "导购id", name = "guideId", example = "导购id")
    private Integer guideId;

    @ApiModelProperty(value = "导购code", name = "guideCode", example = "导购code")
    private String guideCode;

    @ApiModelProperty(value = "评价会员code", name = "evaluateMemberCode", example = "评价会员code")
    private String evaluateMemberCode;

    @ApiModelProperty(value = "会员所属门店", name = "serviceStoreId", example = "评价会员所属门店")
    private Long serviceStoreId;

    @ApiModelProperty(value = "订单会员名", name = "name", example = "订单会员名")
    private String name;

    @ApiModelProperty(value = "订单会员手机", name = "phone", example = "订单会员手机")
    private String phone;

    @ApiModelProperty(value = "订单详细评价", name = "orderDetailEvaluateModelList", example = "订单详细评价")
    private List<OrderDetailEvaluateModel> orderDetailEvaluateModelList;

    @ApiModelProperty(value = "图片存储域名", name = "domain", example = "图片存储域名")
    private String domain;

}
