package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrIntegralApiService {
    /**
     * 查询ur积分记录
     *
     * @param urIntegralRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urIntegral/getUrIntegralRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<UrIntegralResponseVo>> getUrIntegralRecord(@RequestBody @Valid UrIntegralRequestVo urIntegralRequestVo);

    /**
     *
     * @param urIntegralSaveRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urIntegral/integralAdjust", method = RequestMethod.POST)
    ResponseData<String> integralAdjust(@RequestBody @Valid UrIntegralSaveRequestVo urIntegralSaveRequestVo);



    @RequestMapping(value = "/api/urIntegral/queryIntegralRecord", method = RequestMethod.POST)
    ResponseData<List<UrIntegralQueryResponseVo>> queryIntegralRecord(@RequestBody @Valid UrIntegralQueryRequestVo urIntegralQueryRequestVo);

    @RequestMapping(value = "/api/urIntegral/queryIntegralDeduction", method = RequestMethod.POST)
    ResponseData<UrIntegralDeductionResponseVo> queryIntegralDeduction(@RequestBody @Valid UrIntegralDeductionRequestVo urIntegralDeductionRequestVo);

    /**
     * UR获取过期积分, 支持多品牌获取
     * @param urExpireIntegralQueryReqVo
     * @return
     */
    @RequestMapping(value = "/api/urIntegral/getWillExpirePoints", method = RequestMethod.POST)
    ResponseData<UrExpireIntegralResVo> getWillExpirePoints(@RequestBody @Valid UrExpireIntegralQueryReqVo urExpireIntegralQueryReqVo);

    /**
     * UR多品牌积分调整接口
     * @param urIntegralSaveRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urIntegral/moreBrandIntegralAdjust", method = RequestMethod.POST)
    ResponseData<String> moreBrandIntegralAdjust(@RequestBody @Valid UrIntegralSaveRequestVo urIntegralSaveRequestVo);

}
