package com.bizvane.members.facade.models.query;

import com.bizvane.members.facade.utils.EncryptPhone;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: houkai
 * @Date: 2018/9/10 09:22
 * @Description: 发送短信消息
 */
@Data
@EncryptPhone
public class FetchMessagePo {

    private String memberCode;

    private String openId;

    private String memberName;

    @EncryptPhone
    private String memberPhone;

    @ApiModelProperty(
            value = "所属品牌id",
            name = "sysBrandId",
            required = false,
            example = ""
    )
    private Long sysBrandId;

    private Long sysCompanyId;

    private Long wxPublicId;
    /**
     * 会员所属公众号昵称
     */
    private String nickName;

    private String cardNumber;

    private String brandName;
    /**
     * 是否关注公众号
     */
    private Integer focus;

    private String sendWxmember;

    /**
     * 服务门店线下code
     */
    private String serviceStoreCode;

    private Long serviceStoreId;

    private String integral;
    /*@ApiModelProperty(
            value = "当前积分",
            name = "nowIntegral",
            required = false,
            example = ""
    )
    private String nowIntegral;

    @ApiModelProperty(
            value = "过期积分",
            name = "changeIntegral",
            required = false,
            example = ""
    )
    private String expireIntegral;*/

    private String areaCode;
}
