package com.bizvane.members.facade.models.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 会员积分卡表
 * </p>
 *
 * @author Trump
 * @since 2025-04-14
 */
@Getter
@Setter
@TableName("t_mbr_integral_card")
@ApiModel(value = "TMbrIntegralCardPO对象", description = "会员积分卡表")
public class TMbrIntegralCardPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId(value = "mbr_integral_card_id", type = IdType.AUTO)
    private Long mbrIntegralCardId;

    @ApiModelProperty("企业id")
    private Long sysCompanyId;

    @ApiModelProperty("品牌id")
    private Long sysBrandId;

    @ApiModelProperty("会员code")
    private String memberCode;

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Byte valid;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private Long modifiedUserId;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;
}
