package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 导入手机号批量帖标签
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年07月23日 11:46:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ImportBatchAddLabelReqVo {
    /**
     * excel七牛云地址
     */
    private String url;

    /**
     * 1 帖标签 2撕标签
     */
    @NotNull
    @ApiModelProperty(value = "1 帖标签 2撕标签")
    private Integer type;

    /**
     * 标签id
     */
    private Long labelId;


    @ApiModelProperty(value = "标签Id列表", name = "labelIds")
    private List<Long> labelIds;

    @ApiModelProperty(value = "批次号", name = "批次号")
    private String batchNo;

    /**
     * 标签名称
     */
    private String labelName;


    @ApiModelProperty(value = "账号id")
    private Long sysAccountId;
    private Long sysCompanyId;
    private Long brandId;
    @ApiModelProperty(value = "运营组织code")
    private String onlineOrgCode;

}
