package com.bizvane.members.facade.exception;

import com.bizvane.utils.enumutils.SysResponseEnum;

public class BizvaneMembersException extends RuntimeException {

    private String message;
    private int code;
    private Object data;

    public BizvaneMembersException(String message) {
        this.code = SysResponseEnum.FAILED.getCode();
        this.message = message;
    }

    public BizvaneMembersException(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public BizvaneMembersException(int code, Object data, String message) {
        this.code = SysResponseEnum.FAILED.getCode();
        this.message = message;
        this.data = data;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public int getCode() {
        return code;
    }

    public Object getData() {
        return data;
    }
}
