package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Author: houkai
 * @Date: 2018/7/17 17:36
 * @Description:会员分组类型
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_group_type_def")
public class MbrGroupTypeModel extends BaseModel implements Serializable {


    private static final long serialVersionUID = 1076232788621497181L;

    @Id
    @ApiModelProperty(value = "组类型id", name = "mbrGroupTypeDefId", example = "组类型id")
    private Long mbrGroupTypeDefId;

    @ApiModelProperty(value = "归属企业", name = "sysCompanyId", example = "归属企业")
    private Long sysCompanyId;

    @ApiModelProperty(value = "归属品牌:0=表示系统默认,归属所有企业", name = "brandId", example = "归属品牌:0=表示系统默认,归属所有企业")
    private Long brandId;

    @ApiModelProperty(value = "分组类型code", name = "groupTypeCode", example = "分组类型code")
    private String groupTypeCode;

    @ApiModelProperty(value = "分组类型名称", name = "groupTypeName", example = "分组类型名称")
    private String groupTypeName;

    @ApiModelProperty(value = "创建人所属组织", name = "onlineOrgCode", example = "创建人所属组织")
    private String onlineOrgCode;

}
