package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/7/24 16:24
 * @Description:
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_order_detail")
public class OrderDetailModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6159745369023884791L;

    @Id
    @ApiModelProperty(value = "订单详情主键", name = "mbrOrderDetailId", example = "订单详情主键")
    private Long mbrOrderDetailId;

    @ApiModelProperty(value = "渠道id", name = "sysChannelId")
    private Long sysChannelId;

    @ApiModelProperty(value = "所属会员", name = "memberCode", example = "所属会员")
    private String memberCode;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "所属订单", name = "orderNo", example = "所属订单")
    private String orderNo;

    @ApiModelProperty(value = "订单详情编号", name = "orderDetailNo", example = "订单详情编号")
    private String orderDetailNo;

    @ApiModelProperty(value = "条码", name = "productItemId", example = "条码")
    private String productItemId;

    @ApiModelProperty(value = "数量", name = "quantity", example = "数量")
    private Integer quantity;

    @ApiModelProperty(value = "数量小数型", name = "quantityDecimal", example = "数量小数型")
    private BigDecimal quantityDecimal;

    @ApiModelProperty(value = "明细状态", name = "detailStatus", example = "明细状态")
    private String detailStatus;

    @ApiModelProperty(value = "规格（商品样式）", name = "specification", example = "规格（商品样式）")
    private String specification;

    @ApiModelProperty(value = "颜色", name = "specification", example = "颜色")
    private String color;

    @ApiModelProperty(value = "大小", name = "specification", example = "大小")
    private String size;

    @ApiModelProperty(value = "商品编号", name = "productNo", example = "商品编号")
    private String productNo;

    @ApiModelProperty(value = "商品名称", name = "productName", example = "商品名称")
    private String productName;

    @ApiModelProperty(value = "吊牌价", name = "tagPrice", example = "吊牌价")
    private BigDecimal tagPrice;

    @ApiModelProperty(value = "成交价", name = "tradeAmount", example = "成交价")
    private BigDecimal tradeAmountDetail;

    @ApiModelProperty(value = "成交价总金额(trade_amount_detail*数量)", name = "tradeDetailTotalAmount", example = "成交价(trade_amount_detail*数量)")
    private BigDecimal tradeDetailTotalAmount;

    @ApiModelProperty(value = "活动价", name = "activityPrice", example = "活动价")
    private BigDecimal activityPrice;

    @ApiModelProperty(value = "活动ID", name = "activityId", example = "活动ID")
    private Long activityId;

    @ApiModelProperty(value = "是否参与活动1:是,2:否", name = "activity", example = "是否参与活动1:是,2:否")
    private Integer activity;

    @ApiModelProperty(value = "商品导购线下code", name = "offlineProductGuideCode", example = "商品导购线下code")
    private String offlineProductGuideCode;

    @ApiModelProperty(value = "商品导购name", name = "productGuideName", example = "商品导购name")
    private String productGuideName;

    @ApiModelProperty(value = "商品导购Id", name = "productGuideId", example = "商品导购Id")
    private Long productGuideId;

    @ApiModelProperty(value = "线下更新时间", name = "offlineUpdateDate", example = "线下更新时间")
    private Date offlineUpdateDate;

    @ApiModelProperty(value = "线下企业code", name = "companyCode", example = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(value = "线下品牌code", name = "brandCode", example = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(value = "线下会员id", name = "erpId", example = "线下会员id")
    private String erpId;

    @ApiModelProperty(value = "UR字段  正价、特价、正特价", name = "specialPriceFlag", example = "UR字段  正价、特价、正特价")
    private Integer specialPriceFlag;

    @ApiModelProperty(value = "UR SKU", name = "sku", example = "UR SKU")
    private String sku;

    @ApiModelProperty(value = "商品折扣", name = "rebate")
    private BigDecimal rebate;


    @ApiModelProperty(value = "商品折扣价", name = "discountPrice")
    private BigDecimal discountPrice;

    @ApiModelProperty(value = "订单服务导购ids", name = "serviceGuideIds")
    private String serviceGuideIds;

    @ApiModelProperty(value = "商品对应sku图片", name = "skuImg")
    private String skuImg;

    @ApiModelProperty(value = "店铺服务导购提成比例(多导购)", name = "serviceGuideProportion")
    private String serviceGuideProportion;

}
