package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/27.
 */
public enum IntegralChangeTypeEnum {
    /**
     * 积分增减类型 支出
     */
    Expend("1", "支出"),
    /**
     * 积分增减类型 收入
     */
    INCOME("2", "收入"),
    /**
     * 积分增减类型 过期
     */
    EXPIRED("3", "过期");

    private String code;

    private String msg;

    IntegralChangeTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static IntegralChangeTypeEnum getIntegralChangeTypeEnum(String code) {
        for (IntegralChangeTypeEnum type : IntegralChangeTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getIntegralChangeTypeMsg(String code) {
        for (IntegralChangeTypeEnum type : IntegralChangeTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return null;
    }
}
