package com.bizvane.members.facade.dto.tree3;

import com.bizvane.members.facade.utils.EncryptPhone;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@EncryptPhone
@Data
public class MbrIntegralSettlementDetailDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("手机号")
    @EncryptPhone
    private String phone;

    @ApiModelProperty("卡号")
    private String cardNo;

    @ApiModelProperty("积分使用流水号")
    private String useChangeBills;

    @ApiModelProperty("变更类型")
    private String changeWayName;

    @ApiModelProperty("积分数")
    private Integer changeIntegral;

    @ApiModelProperty("业务类型")
    private String businessWayName;

    @ApiModelProperty("使用事业部code")
    private String useOfflineOrgCode;

    @ApiModelProperty("使用事业部名称")
    private String useOfflineOrgName;

    @ApiModelProperty("使用/发放时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeDate;

    @ApiModelProperty("积分发放流水号")
    private String changeBills;

    @ApiModelProperty("发放事业部code")
    private String offlineOrgCode;

    @ApiModelProperty("发放事业部名称")
    private String offlineOrgName;
}
