package com.bizvane.members.facade.service.alipay.electcard;

import com.bizvane.members.facade.models.po.MbrAlipayElectCardPo;
import com.bizvane.members.facade.vo.alipay.electcard.MbrAlipayElectCardVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberAlipayElectCardFeign {

    /**
     * 根据品牌id查询支付宝电子会员卡模板
     */
    @PostMapping("/memberAlipayElectCard/queryAlipayElectCardByBrandId")
    ResponseData<MbrAlipayElectCardVo> queryAlipayElectCardByBrandId(@RequestBody MbrAlipayElectCardPo mbrAlipayElectCardPo);
}
