package com.bizvane.members.facade.enums;

public enum BasicFetchTypeEnum {
    /**
     * 取数全量标志
     */
    ALL(1, "全量"),

    /**
     * 取数增量标志
     */
    ADD(2, "增量");

    private Integer code;

    private String msg;

    BasicFetchTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (BasicFetchTypeEnum type : BasicFetchTypeEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }

}
