package com.bizvane.members.facade.enums.alipay.electcard;

public enum AlipayElectCardTemplateColumnInfoOperateTypeEnum {

    STATIC_INFO("","staticinfo","静态信息"),
    OPEN_WEB("1","openWeb","打开URL"),
    OPEN_NATIVE("0","openNative","打开二级页面，展现 more中descs")
    ;

    AlipayElectCardTemplateColumnInfoOperateTypeEnum(String type, String code, String msg) {
        this.type = type;
        this.code = code;
        this.msg = msg;
    }

    private String type;
    private String code;
    private String msg;

    public String getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static String getOperateTypeCode(String type) {
        for (AlipayElectCardTemplateColumnInfoOperateTypeEnum columnInfoOperateTypeEnum : AlipayElectCardTemplateColumnInfoOperateTypeEnum.values()) {
            if (columnInfoOperateTypeEnum.getType().equals(type)) {
                return columnInfoOperateTypeEnum.getCode();
            }
        }

        return AlipayElectCardTemplateColumnInfoOperateTypeEnum.STATIC_INFO.getCode();
    }
}
