package com.bizvane.members.facade.ur.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UrConsumeStatisticsResVo {

    /**
     * 商品名
     */
    private String firstBuySpu;

    /**
     * 款式名称
     */
    private String firstBuyStyle;

    /**
     * 服装的颜色
     */
    private String firstBuyColor;

    /**
     * 用户注册后第一件购买服装时间
     */
    private Date firstBuyTime;

    /**
     * 会员注册时间
     */
    private Date registerAt;

    /**
     * 购物次数最多的门店名称
     */
    private String oftenLocation;

    /**
     * 购物次数
     */
    private Integer consumptionNum;

    /**
     * 消费金额最多的时间
     */
    private Date maxAt;

    /**
     * 最大单笔消费金额
     */
    private BigDecimal maxAmount;
}
