package com.bizvane.members.facade.models.bo;

import com.bizvane.members.facade.models.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 会员标签MemberLabelBo
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class MemberLabelBo extends BaseModel implements Serializable {

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    @NotNull(message = "企业id不能为空")
    private Long sysCompanyId;

    @ApiModelProperty(value = "所属品牌", name = "brandId", example = "所属品牌")
    @NotNull(message = "品牌id不能为空")
    private Long brandId;

    @ApiModelProperty(value = "标签分组id", name = "labelGroupId", example = "标签分组")
    private Long mbrLabelGroupDefId;

    @ApiModelProperty(value = "标签分组名称", name = "labelTypeName", example = "标签分组名称")
    @NotNull(message = "标签分组名称不能为空")
    private String labelTypeName;

    @ApiModelProperty(value = "标签类型（brand-label(默认官方标签) 、cdp-label(CDP标签)）",required = true)
    @NotNull(message = "标签类型不能为空")
    private String labelCategory ="cdp-label";

    @ApiModelProperty(value = "标签集合")
    @NotNull(message = "标签集合不能为空")
    private List<LabelVO> labelList;

    @ApiModelProperty(value = "账号id")
    private Long sysAccountId;


    @EqualsAndHashCode(callSuper = true)
    @Data
    @Valid
    public static class LabelVO extends BaseModel implements Serializable{

        @ApiModelProperty(value = "标签名称", name = "labelName", example = "标签名称")
        @NotNull(message = "标签名称不能为空")
        private String labelName;

        @ApiModelProperty(value = "标签id")
        private Long mbrLabelDefId;

        @ApiModelProperty(value = "标签类型（brand-label(默认官方标签) 、cdp-label(CDP标签)）",required = true)
        @NotNull(message = "标签类型不能为空")
        private String labelCategory ="cdp-label";

    }

}
