package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.RegionModel;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/20 13:58
 * @Description: 区域
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface RegionApiService {
    /**
     * 解析文件查询区域treeJson
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/api/region/queryRegionTreeJson", method = RequestMethod.POST)
    ResponseData<List<RegionModel>> queryRegionTreeJson();
}
