package com.bizvane.members.facade.vo.yanzhiwu;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 会员第三方绑定渠道vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月12日 11:19:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MemberThirdBindChannelRequestVo {
    /**
     * 企业id
     */
    @ApiModelProperty(value="企业id")
    @NotNull
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    @ApiModelProperty(value="品牌id")
    @NotNull
    private Long brandId;

    /**
     * 会员code
     */
    @ApiModelProperty(value="会员code")
    @NotEmpty
    private String memberCode;

    /**
     * 渠道类型,1:商帆商城 2:微盟商城 3:有赞商城 4:linkflow 5:京东会员通
     */
    @ApiModelProperty(value="渠道类型,1:商帆商城 2:微盟商城 3:有赞商城 4:linkflow 5:京东会员通")
    @NotNull
    private Integer channelType;

    /**
     * 是否绑定,1：未绑定,2：已绑定,3:已解绑
     */
    @ApiModelProperty(value="是否绑定,1：未绑定,2：已绑定,3:已解绑")
    @NotNull
    private Integer bindType;

    /**
     * 推广渠道来源,子渠道,来源渠道记录
     */
    @ApiModelProperty(value="推广渠道来源,子渠道,来源渠道记录")
    private String subChannelSource;

    /**
     * 是否开卡渠道：1是，0不是
     */
    @ApiModelProperty(value="是否开卡渠道：1是，0不是")
    private Boolean channelOpenCard;

    /**
     * 第三方渠道unionid
     */
    @ApiModelProperty(value="第三方渠道unionid")
    private String unionId;

    /**
     * 第三方渠道appId
     */
    @ApiModelProperty(value="第三方渠道appId")
    private String channelAppId;

    /**
     * 第三方渠道openid
     */
    @ApiModelProperty(value="第三方渠道openid")
    private String openId;

    /**
     * 开卡门店code
     */
    @ApiModelProperty(value="开卡门店code")
    private Long openCardStoreCode;

    /**
     * 开卡导购code
     */
    @ApiModelProperty(value="开卡导购code")
    private Long openCardGuideCode;

    /**
     * 渠道昵称
     */
    @ApiModelProperty(value="渠道昵称")
    private String nick;

    /**
     * 渠道头像
     */
    @ApiModelProperty(value="渠道头像")
    private String headPortraits;

    /**
     * 性别,女：0 男：1
     */
    @ApiModelProperty(value="性别,女：1 男：2 未知：3" )
    private String gender;

    /**
     * 省份
     */
    @ApiModelProperty(value="省份")
    private String province;

    /**
     * 城市
     */
    @ApiModelProperty(value="城市")
    private String city;

    /**
     * 区县
     */
    @ApiModelProperty(value="区县")
    private String county;

    /**
     * 绑定时间
     */
    @ApiModelProperty(value="绑定时间")
    private Date bindTime;

    /**
     * 解绑时间
     */
    @ApiModelProperty(value="解绑时间")
    private Date unbindTime;

    /**
     * 渠道分享人openid
     */
    @ApiModelProperty(value="渠道分享人openid")
    private String referrerOpenid;
}
