package com.bizvane.members.facade.vo.qywx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class IndividualRecruitVo implements Serializable {

    @ApiModelProperty(value = "公司id", name = "sysCompanyId")
    @NotNull
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "导购id", name = "guideId")
    private Long guideId;

    @ApiModelProperty(value = "店铺id", name = "storeId")
    @NotNull
    private Long storeId;

    @ApiModelProperty(value = "开始时间", name = "begin")
    private Date beginTime;

    @ApiModelProperty(value = "结束时间", name = "end")
    private Date endTime;


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(sysCompanyId).append(brandId).append(storeId);
        if (guideId != null) {
            sb.append(guideId);
        }
        return sb.toString();
    }
}
