package com.bizvane.members.facade.es.pojo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode
@Document(indexName = "t_mbr_members", type = "doc")
public class BasicMembersInfoSearchPojo {

    /**
     * //企业id
     */
    private Long sysCompanyId;
    /**
     * //品牌号
     */
    private Long brandId;

    private String offlineBrandCode;

    /**
     * //会员code
     */
    @Id
    private String memberCode;

    /**
     * //会员卡号
     */
    private String cardNo;

    /**
     * //姓名
     */
    private String name;

    /**
     * //手机号
     */
    private String phone;

    /**
     * //身份证
     */
    private String idCard;

    /**
     * //女:0 男:1  2:未知
     */
    private String gender;

    /**
     * //等级id
     */
    private Long levelId;

    /**
     * //省
     */
    private String province;
    /**
     * //市
     */
    private String city;
    /**
     * //区
     */
    private String county;

    /**
     * //总可用积分
     */
    private Integer countIntegral;

    /**
     * //是否关注,1：未关注,2：已关注,3:已取关
     *     //@Field(type = FieldType.Date)
     */
    private String focus;

    /**
     * //会员头像
     */
    private String headPortraits;

    private String wxNick;

    private Long serviceStoreId;

    private Long serviceGuideId;

    private String erpId;

    private String offlineCardNo;

    /**
     * //会员来源
     */
    private String membersFrom;
    /**
     * //会员来源时间
     */
    @Field(type = FieldType.Date, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS+0800")
    private Date dateFrom;
    /**
     * //会员标注，已读未读
     */
    private Integer mark;
    /**
     * //是否企业好友
     */
    private Integer companyFriend;
    /**
     * //会员导购好友集合，以-隔开
     */
    private String companyGuideFriends;
    /**
     * //会员备注
     */
    private String memberComment;
    /**
     * //好友userid
     */
    private String externalUserId;
    /**
     * //最后聊天时间
     */
    private Date lastChatTime;

    /**
     * //会员标签
     */
    private String labelIds;

    /**
     * //会员自定义标签
     */
    private String customLabelIds;

    private String wxUnionId;

    private String birthdayMd;


    private Date lastBuyTime;
    private BigDecimal consumeAmountAll;
    private Integer consumeNumberAll;

    private BigDecimal consumeAmount3;
    private Integer consumeNumber3;
    /**
     * //会员的服务门店
     */
    private String serviceStoreCode;

    private String areaCode;

    @Field(type = FieldType.Date, pattern = "yyyy-MM-dd")
    private Date birthday;
}
