package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.models.GetMbrLabelListByCodeAndNameVO;
import com.bizvane.members.facade.models.MemberLabelModel;
import com.bizvane.members.facade.models.MemberLabelTypeModel;
import com.bizvane.members.facade.models.bo.MemberLabelBo;
import com.bizvane.members.facade.models.po.MbrLabelDefPO;
import com.bizvane.members.facade.vo.ImportBatchAddLabelReqVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MbrLabelServiceRpc {

    @PostMapping("/memberLabel/updateTagIdByMbrLabelId")
    ResponseData<String> updateTagIdByMbrLabelId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("mbrLabelDefId")Long mbrLabelDefId, @RequestParam("wxqyTagId")String wxqyTagId);

    @PostMapping("/memberLabelGroup/updateTagGroupIdByMbrLabelGroupId")
    ResponseData<String> updateTagGroupIdByMbrLabelGroupId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("mbrLabelGroupDefId")Long mbrLabelGroupDefId, @RequestParam("wxqyTagGroupId")String wxqyTagGroupId);

    @PostMapping("/memberLabelGroup/deleteByWxqyTagGroupId")
    ResponseData<String> deleteByWxqyTagGroupId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("wxqyTagGroupId")String wxqyTagGroupId);

    @PostMapping("/memberLabel/deleteByWxqyCorpTagId")
    ResponseData<String> deleteByWxqyCorpTagId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("wxqyTagId")String wxqyTagId);

    @PostMapping("/memberLabel/getMemberLabelDefById")
    ResponseData<MbrLabelDefPO> getMemberLabelDefById(@RequestParam("mbrLabelDefId")Long mbrLabelDefId);

    @PostMapping("/memberLabelGroup/getMbrLabelGroupById")
    ResponseData<MemberLabelTypeModel> getMbrLabelGroupById(@RequestParam("mbrLabelDefId")Long mbrLabelDefId);

    @PostMapping("/memberLabel/getMemberLabelDefByIdList")
    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByIdList(@RequestBody List<Long> mbrLabelDefIdList);

    @PostMapping("/memberLabelGroup/getMbrLabelGroupByIdList")
    ResponseData<List<MemberLabelTypeModel>> getMbrLabelGroupByIdList(@RequestBody List<Long> mbrLabelGroupIdList);

    @PostMapping("/memberLabelGroup/getMbrLabelGroupBySysBrandId")
    ResponseData<List<MemberLabelTypeModel>> getMbrLabelGroupBySysBrandId(@RequestParam("sysBrandId") Long sysBrandId);

    @PostMapping("/memberLabel/getMemberLabelDefBySysBrandId")
    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefBySysBrandId(@RequestParam("sysBrandId") Long sysBrandId);

    @PostMapping("/memberLabel/deleteByMbrLabelGroupId")
    ResponseData<String> deleteByMbrLabelGroupId(@RequestParam("sysBrandId") Long sysBrandId, @RequestParam("mbrLabelGroupId")Long mbrLabelGroupId);

    @PostMapping("/memberLabel/getMemberLabelDefByMbrLabelGroupId")
    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByMbrLabelGroupId(@RequestParam("mbrLabelGroupId") Long mbrLabelGroupId);

    @PostMapping("/memberLabelGroup/getMbrLabelGroupByWxqyCorpGroupId")
    ResponseData<MemberLabelTypeModel> getMbrLabelGroupByWxqyCorpGroupId(@RequestParam("sysBrandId")Long sysBrandId, @RequestParam("wxqyCorpGroupId")String wxqyCorpGroupId);

    @PostMapping("/memberLabel/getMemberLabelDefByLabelCodeList")
    ResponseData<List<MbrLabelDefPO>> getMemberLabelDefByLabelCodeList(@RequestBody GetMbrLabelListByCodeAndNameVO vo);

    @PostMapping("/memberLabel/getMbrLabelTypeByTagIdList")
    ResponseData<List<MbrLabelDefPO>> getMbrLabelTypeByTagIdList(@RequestParam("sysBrandId")Long sysBrandId, @RequestParam("wxqyTagIdList")List<String> wxqyTagIdList);

    @PostMapping("/memberLabel/saveOrModifyLabel")
    @ApiOperation(value = "保存修改标签组和标签", notes = "CDP使用")
    ResponseData<MemberLabelBo> saveOrModifyLabel(@RequestBody @Validated MemberLabelBo mbrLabelBo);

    @ApiOperation(value = "批量撕标签", notes = "CDP使用")
    @PostMapping(value = "/memberLabel/BatchPostLabelTaskForCDP")
    ResponseData<String> BatchPostLabelTaskForCDP(@RequestBody ImportBatchAddLabelReqVo requestVo);

    @PostMapping("/memberLabel/saveLabelDef")
    ResponseData<String> saveLabelDef(@RequestBody @Validated MemberLabelModel mbrLabelDefPO);

    @PostMapping("/memberLabel/updateLabelDefByLabelDefId")
    ResponseData<String> updateLabelDefByLabelDefId(@RequestBody @Validated MemberLabelModel mbrLabelDefPO);

    @PostMapping("/memberLabelGroup/saveLabelGroup")
    ResponseData<String> saveLabelGroup(@RequestBody @Validated MemberLabelTypeModel memberLabelTypeModel);

    @PostMapping("/memberLabelGroup/updateLabelGroupByLabelGroupDefId")
    ResponseData<String> updateLabelGroupByLabelGroupDefId(@RequestBody @Validated MemberLabelTypeModel memberLabelTypeModel);

}
