package com.bizvane.members.facade.service.tree3;

import com.bizvane.members.facade.vo.tree3.Tree3AutoLabelReqVo;
import com.bizvane.members.facade.vo.tree3.Tree3AutoLabelRspVo;
import com.bizvane.members.facade.vo.tree3.mq.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * 自动标签
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface Mbr3TreeAutoLabelService {

    /**
     * 直接贴自动标签
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/tree3/addAutoLabel", method = RequestMethod.POST)
    ResponseData<Tree3AutoLabelRspVo> autoTagRelationshipDivision(@RequestBody @Valid Tree3AutoLabelReqVo reqVo);

    /**
     * 扫码 traceId 贴标签
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/tree3/mq/traceAutoLabel", method = RequestMethod.POST)
    ResponseData<SendResult> traceAutoLabel(@RequestBody @Valid Tree3AutoLabelTraceMqVo reqVo);


    /**
     * 订单同步贴标签
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/tree3/mq/orderSyncAutoLabel", method = RequestMethod.POST)
    ResponseData<SendResult> orderSyncAutoLabel(@RequestBody @Valid Tree3AutoLabelOrderSyncMqVo reqVo);

    /**
     * 开卡贴标签
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/mq/registerAutoLabel", method = RequestMethod.POST)
    ResponseData<SendResult> registerAutoLabel(@RequestBody @Valid Tree3AutoLabelRegisterMqVo reqVo);

    /**
     * 绑卡贴标签
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/mq/bindAutoLabel", method = RequestMethod.POST)
    ResponseData<SendResult> bindAutoLabel(@RequestBody @Valid Tree3AutoLabelBindMqVo reqVo);

    /**
     * 四会活动签到贴标签
     * @param reqVo
     * @return
     */
    @RequestMapping(value = "/mq/siHuiEventAutoLabel", method = RequestMethod.POST)
    ResponseData<SendResult> siHuiEventAutoLabel(@RequestBody @Valid Tree3AutoLabelSiHuiEventMqVo reqVo);
}
