package com.bizvane.members.facade.models.query;

import com.bizvane.members.facade.vo.tree3.IntegralMallQueryIntegralListRsp;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;


@Data
public class IntegralMallOrgIntegralAdjustRes {

	@NotNull
	private Long sysCompanyId;

	@NotNull
	private Long brandId;

	@NotBlank
	private String channelCode;

	/**
	 * 积分变更唯一流水号
	 * */
	@NotBlank
	private String serialNumber;

	@NotBlank
	private String memberCode;

	/**
	 * 变更积分数 如果是扣减 则为负数
	 * */
	@NotEmpty
	private List<OrgIntegralList> orgIntegralList;

	/**
	 * 店铺Code
	 * */
	private String storeCode;

	/**
	 * 变更单据 （订单号）
	 * */
	private String changeBills;

	/**
	 * 变更说明
	 * */
	private String changeRemark;

	/**
	 * 积分调整业务场景code
	 * */
	private String businessWay;

	@Data
	@NoArgsConstructor
	@AllArgsConstructor
	@Builder
	public static class OrgIntegralList {

		private String offlineOrgCode;

		private Integer changeIntegral;
	}
}
