package com.bizvane.members.facade.models.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员通用绑卡渠道表
 * </p>
 *
 * @author Trump
 * @since 2025-04-14
 */
@Getter
@Setter
@TableName("t_mbr_universal_bind_channel")
@ApiModel(value = "TMbrUniversalBindChannelPO对象", description = "会员通用绑卡渠道表")
public class TMbrUniversalBindChannelPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId(value = "mbr_universal_bind_id", type = IdType.AUTO)
    private Long mbrUniversalBindId;

    @ApiModelProperty("企业id")
    private Long sysCompanyId;

    @ApiModelProperty("品牌id")
    private Long brandId;

    @ApiModelProperty("会员code")
    private String memberCode;

    @ApiModelProperty("渠道类型,1:商帆商城 2:微盟商城 3:有赞商城 4:linkflow 5:京东会员通 6:南讯渠道")
    private Integer channelType;

    @ApiModelProperty("是否绑定,1：未绑定,2：已绑定,3:已解绑")
    private Integer bindType;

    @ApiModelProperty("推广渠道来源,子渠道,来源渠道记录")
    private String subChannelSource;

    @ApiModelProperty("是否开卡渠道：1是，0不是")
    private Byte channelOpenCard;

    @ApiModelProperty("第三方渠道unionid")
    private String unionId;

    @ApiModelProperty("第三方渠道appId")
    private String channelAppId;

    @ApiModelProperty("第三方渠道openid")
    private String openId;

    @ApiModelProperty("开卡门店code")
    private Long openCardStoreCode;

    @ApiModelProperty("开卡导购code")
    private Long openCardGuideCode;

    @ApiModelProperty("渠道昵称")
    private String nick;

    @ApiModelProperty("渠道头像")
    private String headPortraits;

    @ApiModelProperty("性别,女：1 男：2 未知：3")
    private String gender;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("区县")
    private String county;

    @ApiModelProperty("绑定时间")
    private LocalDateTime bindTime;

    @ApiModelProperty("解绑时间")
    private LocalDateTime unbindTime;

    @ApiModelProperty("渠道分享人openid")
    private String referrerOpenid;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Byte valid;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private Long modifiedUserId;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

    @ApiModelProperty("版本号")
    @Version
    private Integer version;

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("来源code")
    private String sourceCode;

    @ApiModelProperty("外部系统id")
    private String externalId;

    @ApiModelProperty("渠道门店code")
    private String storeCode;

    @ApiModelProperty("渠道导购code")
    private String guideCode;

    @ApiModelProperty("潜客注册时间")
    private LocalDateTime qkBindTime;
}
