package com.bizvane.members.facade.models.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员积分使用记录
 * </p>
 *
 * @author Trump
 * @since 2025-04-14
 */
@Getter
@Setter
@TableName("t_mbr_integral_use_record")
@ApiModel(value = "TMbrIntegralUseRecordPO对象", description = "会员积分使用记录")
public class TMbrIntegralUseRecordPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId(value = "mbr_integral_use_record_id", type = IdType.AUTO)
    private Long mbrIntegralUseRecordId;

    @ApiModelProperty("企业id")
    private Long sysCompanyId;

    @ApiModelProperty("品牌id")
    private Long brandId;

    @ApiModelProperty("流水code")
    private String recordCode;

    @ApiModelProperty("会员code")
    private String memberCode;

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @ApiModelProperty("已使用积分")
    private Integer usedIntegral;

    @ApiModelProperty("原单积分流水code")
    private String originalRecordCode;

    @ApiModelProperty("原单事业部code")
    private String originalOfflineOrgCode;

    @ApiModelProperty("原单变动时间")
    private LocalDateTime originalChangeDate;

    @ApiModelProperty("原单号业务类型枚举")
    private String originalBusinessWay;

    @ApiModelProperty("原单可用积分")
    private Integer originalAvailableIntegral;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Byte valid;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private Long modifiedUserId;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

    @ApiModelProperty("版本号")
    @Version
    private Integer version;

    @ApiModelProperty("业务类型描述，关联积分流水业务类型字典表描述")
    private String businessDescription;
}
