package com.bizvane.members.facade.enums.tree3;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.concurrent.TimeUnit;

@AllArgsConstructor
public enum Tree3RedisEnum {

    AUTO_LABEL_GROUP("tree3:auto_label_group:%s:%s:%s", "自动标签分组", 10, TimeUnit.MINUTES),
    AUTO_LABEL("tree3:auto_label_group:%s:%s:%s:%s", "", 10, TimeUnit.MINUTES);

    private String key;
    private String desc;
    @Getter
    private long time;
    @Getter
    private TimeUnit timeUnit;

    public static String getAutoLabelGroupKey(Long sysCompanyId, Long sysBrandId, String autoLabelGroupName) {
        return String.format(AUTO_LABEL_GROUP.key, sysCompanyId, sysBrandId, autoLabelGroupName);
    }

    public static String getAutoLabelKey(Long sysCompanyId, Long sysBrandId, String autoLabelGroupName, String autoLabelName) {
        return String.format(AUTO_LABEL_GROUP.key, sysCompanyId, sysBrandId, autoLabelGroupName, autoLabelName);
    }
}
