package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.models.OrderEvaluateModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.models.query.OrderEvaluateQueryPo;
import com.bizvane.members.facade.vo.OrderEvaluateVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.members.facade.vo.StatisticsMemberOrderEvaluateVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/24 09:11
 * @Description:
 */
public interface OrderEvaluateService {
    /**
     * 查询品牌下订单评价列表
     *
     * @param
     * @param pageVo
     * @return
     */
    ResponseData<PageInfo<OrderEvaluateVo>> queryOrderEvaluateList(OrderEvaluateQueryPo orderEvaluateQueryPo, PageVo pageVo);

    /**
     * 查询订单详情
     *
     * @param orderNo
     * @return
     */
    ResponseData<OrderModel> queryOrderInfo(String orderNo);

    /**
     * 查询订单评价详情
     *
     * @param orderNo
     * @return
     */
    ResponseData<OrderEvaluateModel> queryOrderEvaluateInfo(String orderNo);

    /**
     * 查询评价个数
     *
     * @param paraMap
     * @return
     */
    Long queryEvaluateCount(OrderEvaluateQueryPo orderEvaluateQueryPo);

    /**
     * 查询订单评价列表 excel
     *
     * @param
     * @param start
     * @param size
     * @return
     */
    List<OrderEvaluateVo> queryOrderEvaluateList(OrderEvaluateQueryPo orderEvaluateQueryPo, Long start, Long size);

    /**
     * 统计会员评价数据
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @param storeIds
     * @return
     */
    ResponseData<StatisticsMemberOrderEvaluateVo> statisticsMemberOrderEvaluateByMemberCode(Long sysCompanyId, Long sysBrandId, String memberCode, List<Long> storeIds);

}
