package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class PaidMemberRefundVO {

    @NotNull
    @ApiModelProperty(value = "申请人工号", name = "applyWorkCode", example = "")
    private String applyWorkCode;

    @NotNull
    @ApiModelProperty(value = "是否原路退回 1是，0否", name = "isReturnOriginalRoute", example = "")
    private Integer isReturnOriginalRoute;

    @ApiModelProperty(value = "银行卡户名", name = "accountName", example = "")
    private String accountName;

    @ApiModelProperty(value = "开户行", name = "openBank", example = "")
    private String openBank;

    @ApiModelProperty(value = "卡号", name = "cardNumber", example = "")
    private String cardNumber;

    @ApiModelProperty(value = "申请附件列表", name = "applyAttachment", example = "")
    private List<String> applyAttachment;

    @ApiModelProperty(value = "非原路退回说明", name = "nonOriginalReturnInstructions", example = "")
    private String nonOriginalReturnInstructions;

    @ApiModelProperty(value = "会员卡号", name = "memberCardNo", example = "")
    private String memberCardNo;

    @NotNull
    @ApiModelProperty(value = "会员卡等级Code", name = "cardLevelCode", example = "")
    private String cardLevelCode;

    @NotNull
    @ApiModelProperty(value = "会员卡等级名称", name = "cardLevelName", example = "")
    private String cardLevelName;

    @ApiModelProperty(value = "会员手机号", name = "phone", example = "")
    private String phone;

    @NotNull
    @ApiModelProperty(value = "会员Code", name = "memberCode", example = "")
    private String memberCode;

}
