package com.bizvane.members.facade.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

@Data
public class PaidMemberRefundRequestToURVo {
    // 品牌id
    @NotEmpty
    private Long brandId;
    // 手机号
    @NotEmpty
    private Long mobileTel;
    // 卡号
    @NotEmpty
    private String cardCode;
    // 卡级别
    @NotEmpty
    private String cardLevelCode;
    // 卡级别名称
    @NotEmpty
    private String cardLevelName;
    // 退款金额
    @NotEmpty
    private BigDecimal refundAmount;
    // 每日成本
    @NotEmpty
    private BigDecimal dailyCost;
    // 剩余有效天数
    @NotEmpty
    private Integer validDays;
    // 已用权益的优惠券金额
    @NotEmpty
    private BigDecimal usedAmount;
    // 已用权益的优惠券code 用","分割
    private String usedCouponCode;
    // 退款申请时间
    @NotEmpty
    private Long applyTime;

}
