package com.bizvane.members.facade.models.query;

import com.bizvane.members.facade.utils.EncryptPhone;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/10/25 11:48
 * @Description:
 */
@Data
@EncryptPhone
public class CouponMemberPo implements Serializable {

    private static final long serialVersionUID = 9060464380281547177L;

    private List<String> memberCodeList;

    private String cardNo;

    private String name;

    @EncryptPhone
    private String phone;
    /**
     * 卡号拼接
     */
    private String cardNoStr;

    @EncryptPhone
    private String phonesStr;

    private Long sysCompanyId;

    private Long brandId;

    private List<String> cardNoList;

    @EncryptPhone
    private List<String> phoneList;

    private String conditions;

    //企业微信互动历史查询
    private String baseSearchValue;

    //服务店铺
    private Long serviceStoreId;

    private Long serviceGuideId;


    private List<Long> serviceGuideIds;

    private Integer pageNumber = 1;

    private Integer pageSize = 10;

}
