package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.utils.EncryptPhone;
import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/24 16:23
 * @Description:
 */
@Data
@EncryptPhone
public class OrderVo{

    private Long mbrOrderId;
    //订单号
    private String orderNo;

    private BigDecimal tradeAmount;

    private BigDecimal commodityAmount;

    private String discount;

    private Date placeOrderTime;

    private String serviceStoreName;

    private Integer getedIntegral;

    private String serviceGuideNames;

    private String guideNames;

    private Integer commodityNum;

    private Long sysCompanyId;

    private Date billTime;

    private String serviceStoreCode;

    private Long brandId;

    private Date payTime;

    private BigDecimal payMoney;

    //361经销商
    private String corpName;

    //361渠道
    private String channelName;


    @OneToMany(mappedBy = "t_mbr_order", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @JoinColumn(name = "orderNo")
    @Transient
    private List<OrderDetailVo> details;

    @OneToMany(mappedBy = "t_mbr_order", cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    @JoinColumn(name = "orderNo")
    @Transient
    private List<OrderPaymentVo> payments;
    //是否有效
    private Boolean valid;
    //订单类型
    private Integer orderType;
    //手机号
    @EncryptPhone
    private String phone;
    //会员code
    private String memberCode;
    //会员code集合
    private List<String> memberCodeList;
    //开始下单时间
    private Date startPlaceOrderTime;
    //结束下单时间
    private Date endPlaceOrderTime;
    //运营组织
    private String organizationCode;
    //线下运营组织
    private List<String> offlineOrgCodeList;
    //服务门店id
    private List<Long> serviceStoreIdList;

    private Integer orderFrom;

    private String orderFromName;

    private Integer pageNumber;

    private Integer pageSize;



}
