package com.bizvane.members.facade.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 自动标签vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月03日 16:40:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class AutoLabelVo implements Serializable {

    /**
     * 自动标签分组名称
     */
    @ApiModelProperty(value = "自动标签分组名称", name = "name")
    private String labelGroupName;


    /**
     * 自动标签名称
     */
    @ApiModelProperty(value = "自动标签名称", name = "name")
    @NotEmpty
    private String name;

    /**
     * 自动标签描述
     */
    @ApiModelProperty(value = "自动标签描述", name = "desc")
    private String description;

    /**
     * 自动标签更新周期
     */
    @ApiModelProperty(value = "自动标签更新周期", name = "cycleType")
    private Integer cycleType;

    /**
     * 自动标签创建人
     */
    @ApiModelProperty(value = "自动标签创建人", name = "createUser")
    private String createUser;

    /**
     * 自动标签创建时间
     */
    @ApiModelProperty(value = "自动标签创建时间", name = "createDate")
    private Date createDate;


    /**
     * 自动标签状态 1 未计算 2 大数据计算中 3 计算完成 4 CRM写入中 5 写入完成
     */
    @ApiModelProperty(value = "自动标签状态", name = "status")
    private Integer status;

    /**
     * 操作日志
     */
    @ApiModelProperty(value = "操作日志", name = "autoLabelOperateRecordList")
    private List<AutoLabelOperateRecord> autoLabelOperateRecordList;


    @Data
    public static class AutoLabelOperateRecord{

        /**
         * 操作时间
         */
        @ApiModelProperty(value = "操作时间", name = "operateDate")
        private Date operateDate;

        /**
         * 操作人
         */
        @ApiModelProperty(value = "操作人", name = "operateUser")
        private String operateUser;

        /**
         * 操作类型
         */
        @ApiModelProperty(value = "操作类型", name = "operateType")
        private Integer operateType;

    }
}
