package com.bizvane.members.facade.models.po;

import java.io.Serializable;
import java.util.Date;

/**
 * t_mbr_send_record 会员自动发券记录表
 * @author Bizvane
 */
public class MbrSendRecordPo implements Serializable {
    /**
     * 主键id
     */
    private Long mbrSendRecordId;

    /**
     * 公司id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;


    /**
     * 会员code
     */
    private String memberCode;

    /**
     * 券定义id,多个，分隔
     */
    private String couponIds;

    /**
     * 发券时间
     */
    private Date sendDate;

    public Long getSysCompanyId() {
        return sysCompanyId;
    }

    public void setSysCompanyId(Long sysCompanyId) {
        this.sysCompanyId = sysCompanyId;
    }

    public Long getSysBrandId() {
        return sysBrandId;
    }

    public void setSysBrandId(Long sysBrandId) {
        this.sysBrandId = sysBrandId;
    }

    /**
     * t_mbr_send_record
     */
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     * @return mbr_send_record_id 主键id
     */
    public Long getMbrSendRecordId() {
        return mbrSendRecordId;
    }

    /**
     * 主键id
     * @param mbrSendRecordId 主键id
     */
    public void setMbrSendRecordId(Long mbrSendRecordId) {
        this.mbrSendRecordId = mbrSendRecordId;
    }

    /**
     * 会员code
     * @return member_code 会员code
     */
    public String getMemberCode() {
        return memberCode;
    }

    /**
     * 会员code
     * @param memberCode 会员code
     */
    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode == null ? null : memberCode.trim();
    }

    /**
     * 券定义id,多个，分隔
     * @return coupon_ids 券定义id,多个，分隔
     */
    public String getCouponIds() {
        return couponIds;
    }

    /**
     * 券定义id,多个，分隔
     * @param couponIds 券定义id,多个，分隔
     */
    public void setCouponIds(String couponIds) {
        this.couponIds = couponIds == null ? null : couponIds.trim();
    }

    /**
     * 发券时间
     * @return send_date 发券时间
     */
    public Date getSendDate() {
        return sendDate;
    }

    /**
     * 发券时间
     * @param sendDate 发券时间
     */
    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }

    /**
     * toString
     * @return String 
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", mbrSendRecordId=").append(mbrSendRecordId);
        sb.append(", memberCode=").append(memberCode);
        sb.append(", couponIds=").append(couponIds);
        sb.append(", sendDate=").append(sendDate);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}