/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.members.facade.utils.EncryptCardNo;
import com.bizvane.members.facade.utils.EncryptPhoneProperties;
import com.bizvane.members.facade.utils.PhoneEncryptUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.SpringContextHolder;
import com.bizvane.utils.responseinfo.ResponseData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"aes.mybatisPlugin"}, havingValue="true")
@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class CryptoCardNoPlugin
implements Interceptor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CryptoCardNoPlugin.class);
    private static EncryptPhoneProperties encryptPhoneProperties;
    private BrandServiceRpc brandServiceRpc;
    private static ThreadLocal<Map<String, Object>> mapThreadLocal;
    protected static String KEY;
    protected static String IV;
    private static final String COUNT_SUFFIX = "_COUNT";
    private static final String EXAMPLE_SUFFIX = "Example";
    private static final String SYS_COMPANY_ID = "sysCompanyId";
    private static final String COMPANY_ID = "companyId";
    private static final String SYS_BRAND_ID = "sysBrandId";
    private static final String BRAND_ID = "brandId";
    private static final String METHOD = "method";
    private static final String SELECT_BY_PRIMARY_KEY = "selectByPrimaryKey";
    private static final String ORED_CRITERIA = "oredCriteria";
    private static final String CRITERIA = "criteria";
    private static final String CONDITION = "condition";
    private static final String VALUE = "value";
    private static final String SECOND_VALUE = "secondValue";
    private static final List<String> columnNameList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        String methodName = null;
        Method method = null;
        Object parameter = null;
        try {
            Object[] args = invocation.getArgs();
            MappedStatement mappedStatement = (MappedStatement)args[0];
            String methodPath = mappedStatement.getId();
            methodName = methodPath.substring(methodPath.lastIndexOf(".") + 1);
            method = this.getMethod(methodPath);
            if (method != null && args.length > 1 && this.needEncrypt(parameter = args[1])) {
                CryptoCardNoPlugin.setLocalMethod(method);
                this.paramByDataTypeCrypt(parameter, method, PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT);
                String invocationMethodName = invocation.getMethod().getName();
                if (StrUtil.equals((CharSequence)invocationMethodName, (CharSequence)"query") && args.length > 5) {
                    BoundSql boundSqlOld = (BoundSql)args[5];
                    BoundSql boundSqlNew = mappedStatement.getBoundSql(parameter);
                    String countSql = boundSqlOld.getSql();
                    ReflectUtil.setFieldValue((Object)boundSqlNew, (String)"sql", (Object)countSql);
                    boundSqlOld.getParameterMappings().stream().filter(item -> "First_PageHelper".equals(item.getProperty()) || "Second_PageHelper".equals(item.getProperty())).forEach(item -> boundSqlNew.getParameterMappings().add(item));
                    args[5] = boundSqlNew;
                } else if (StrUtil.equals((CharSequence)invocationMethodName, (CharSequence)"update") && args.length == 2) {
                    args[1] = parameter;
                }
            }
        }
        catch (Exception e) {
            log.error("PhoneCryptoPlugin encrypt exception: {}", (Throwable)e);
        }
        Object resultObj = invocation.proceed();
        try {
            if (method != null && !CryptoCardNoPlugin.isEndWithCount(methodName) && this.needEncrypt(resultObj)) {
                resultObj = this.resultByDataTypeDecrypt(resultObj);
                this.paramByDataTypeCrypt(parameter, method, PhoneEncryptUtil.EncryptDecryptPhoneEnum.DECRYPT);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("PhoneCryptoPlugin decrypt exception: {}", (Throwable)e);
        }
        finally {
            CryptoCardNoPlugin.removeLocalBrandId();
        }
        return resultObj;
    }

    private Method getMethod(String methodPath) throws ClassNotFoundException {
        String methodName = methodPath.substring(methodPath.lastIndexOf(".") + 1);
        String classPath = methodPath.substring(0, methodPath.lastIndexOf("."));
        Class<?> clazz = this.getClass().getClassLoader().loadClass(classPath);
        Object bean = SpringContextHolder.getBean(clazz);
        Class<?> realClass = bean.getClass();
        Method method = ReflectUtil.getMethodByName(realClass, (String)methodName);
        if (method == null && CryptoCardNoPlugin.isEndWithCount(methodName)) {
            method = ReflectUtil.getMethodByName(realClass, (String)methodName.substring(0, methodName.length() - 6));
        }
        return method;
    }

    private void paramByDataTypeCrypt(Object paramObj, Method method, PhoneEncryptUtil.EncryptDecryptPhoneEnum encryptDecryptPhoneEnum) throws Exception {
        if (paramObj == null || method == null) {
            return;
        }
        String className = paramObj.getClass().getName();
        if (paramObj instanceof Map) {
            Map paramMap = (Map)paramObj;
            for (Map.Entry entry : paramMap.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                if (value instanceof List) {
                    this.paramByDataTypeCrypt(value, method, encryptDecryptPhoneEnum);
                    continue;
                }
                EncryptCardNo annotation = value.getClass().getAnnotation(EncryptCardNo.class);
                if (annotation == null && !CryptoCardNoPlugin.isEndWithExample(value.getClass().getName())) continue;
                this.paramByDataTypeCrypt(value, method, encryptDecryptPhoneEnum);
            }
        } else if (CryptoCardNoPlugin.isEndWithExample(className)) {
            this.selectForExample(method, paramObj);
        } else if (paramObj instanceof List) {
            List paramList = (List)paramObj;
            for (Object ob : paramList) {
                Class<?> aClass;
                EncryptCardNo annotation;
                if (ob == null || (annotation = (aClass = ob.getClass()).getAnnotation(EncryptCardNo.class)) == null) continue;
                this.paramByDataTypeCrypt(ob, method, encryptDecryptPhoneEnum);
            }
        } else {
            this.phoneFieldProcess(paramObj, encryptDecryptPhoneEnum);
        }
    }

    private Object resultByDataTypeDecrypt(Object paramObj) throws ClassNotFoundException {
        PhoneEncryptUtil.EncryptDecryptPhoneEnum encryptDecryptPhoneEnum = PhoneEncryptUtil.EncryptDecryptPhoneEnum.DECRYPT;
        if (paramObj == null) {
            return paramObj;
        }
        if (paramObj instanceof List) {
            List paramList = (List)paramObj;
            for (int i = 0; i < paramList.size(); ++i) {
                Object ob = paramList.get(i);
                if (ob == null) continue;
                Class<?> aClass = ob.getClass();
                EncryptCardNo annotation = aClass.getAnnotation(EncryptCardNo.class);
                if (annotation != null) {
                    ob = this.resultByDataTypeDecrypt(ob);
                }
                paramList.set(i, ob);
            }
        } else {
            EncryptCardNo annotation = paramObj.getClass().getAnnotation(EncryptCardNo.class);
            if (annotation != null) {
                this.phoneFieldProcess(paramObj, encryptDecryptPhoneEnum);
            }
        }
        return paramObj;
    }

    private String stringParameterProcess(String paramObj, PhoneEncryptUtil.EncryptDecryptPhoneEnum encryptDecryptPhoneEnum) {
        try {
            boolean needEncrypt;
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            Method localMethod = CryptoCardNoPlugin.getLocalMethod();
            if (localCompanyId == null && encryptDecryptPhoneEnum.getCode() == PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT.getCode()) {
                log.error("encrypt phone brandId is null stringParameterProcess paramObj: {}, method: {}", (Object)JacksonUtil.bean2Map((Object)paramObj), (Object)JacksonUtil.bean2Json((Object)localMethod));
            }
            if (!(needEncrypt = this.needEncrypt())) {
                return paramObj;
            }
            paramObj = encryptDecryptPhoneEnum.getCode() == PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT.getCode() ? PhoneEncryptUtil.encryptAES(KEY, IV, paramObj) : PhoneEncryptUtil.decryptAES(KEY, IV, paramObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return paramObj;
    }

    private void phoneFieldProcess(Object parameter, PhoneEncryptUtil.EncryptDecryptPhoneEnum encryptDecryptPhoneEnum) {
        Class<?> aClass = parameter.getClass();
        List fieldsListWithAnnotation = FieldUtils.getFieldsListWithAnnotation(aClass, EncryptCardNo.class);
        if (CollUtil.isNotEmpty((Collection)fieldsListWithAnnotation)) {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            Method localMethod = CryptoCardNoPlugin.getLocalMethod();
            if (localCompanyId == null && encryptDecryptPhoneEnum.getCode() == PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT.getCode()) {
                log.error("encrypt phone brandId is null phoneFieldProcess parameter: {}, method: {}", (Object)JacksonUtil.bean2Map((Object)parameter), (Object)JacksonUtil.bean2Json((Object)localMethod));
            }
            fieldsListWithAnnotation.stream().forEach(field -> {
                try {
                    List value = ReflectUtil.getFieldValue((Object)parameter, (Field)field);
                    if (value != null) {
                        if (field.getType().isAssignableFrom(String.class)) {
                            value = this.stringParameterProcess((String)((Object)value), encryptDecryptPhoneEnum);
                        } else if (field.getType().isAssignableFrom(List.class)) {
                            List list = value;
                            value = list.stream().filter(ObjectUtil::isNotNull).map(o -> o instanceof String ? this.stringParameterProcess((String)o, encryptDecryptPhoneEnum) : o).collect(Collectors.toList());
                        }
                        ReflectUtil.setFieldValue((Object)parameter, (Field)field, (Object)value);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void selectForExample(Method method, Object parameter) {
        List fieldsListWithAnnotation;
        Class<?> declaringClass = method.getDeclaringClass();
        Method selectByPrimaryKeyMethod = ReflectUtil.getMethodByName(declaringClass, (String)SELECT_BY_PRIMARY_KEY);
        Class<?> poClass = null;
        if (selectByPrimaryKeyMethod != null) {
            poClass = selectByPrimaryKeyMethod.getReturnType();
        }
        if (CollUtil.isEmpty((Collection)(fieldsListWithAnnotation = FieldUtils.getFieldsListWithAnnotation(poClass, EncryptCardNo.class)))) {
            return;
        }
        fieldsListWithAnnotation.stream().filter(field -> field.getType().equals(String.class) || field.getType().isAssignableFrom(List.class)).forEach(field -> {
            String name = field.getName();
            List oredCriteriaList = (List)ReflectUtil.getFieldValue((Object)parameter, (String)ORED_CRITERIA);
            Object oredCriteria = oredCriteriaList.get(0);
            List criteriaList = (List)ReflectUtil.getFieldValue(oredCriteria, (String)CRITERIA);
            criteriaList.forEach(criteria -> {
                String condition = (String)ReflectUtil.getFieldValue((Object)criteria, (String)CONDITION);
                if (StrUtil.startWith((CharSequence)condition, (CharSequence)StrUtil.toUnderlineCase((CharSequence)name))) {
                    try {
                        List secondValue;
                        List value = ReflectUtil.getFieldValue((Object)criteria, (String)VALUE);
                        if (value != null) {
                            if (value instanceof List) {
                                List valueList = value;
                                value = valueList.stream().map(item -> ObjectUtil.isNotNull((Object)item) && item instanceof String ? this.stringParameterProcess((String)item, PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT) : item).collect(Collectors.toList());
                            } else if (value instanceof String) {
                                value = this.stringParameterProcess((String)((Object)value), PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT);
                            }
                            ReflectUtil.setFieldValue((Object)criteria, (String)VALUE, (Object)value);
                        }
                        if ((secondValue = ReflectUtil.getFieldValue((Object)criteria, (String)SECOND_VALUE)) != null) {
                            if (secondValue instanceof List) {
                                List valueList = secondValue;
                                secondValue = valueList.stream().map(item -> ObjectUtil.isNotNull((Object)item) && item instanceof String ? this.stringParameterProcess((String)item, PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT) : item).collect(Collectors.toList());
                            } else if (secondValue instanceof String) {
                                secondValue = this.stringParameterProcess((String)((Object)secondValue), PhoneEncryptUtil.EncryptDecryptPhoneEnum.ENCRYPT);
                            }
                            ReflectUtil.setFieldValue((Object)criteria, (String)SECOND_VALUE, (Object)secondValue);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        });
    }

    private static void parseMapForExample(Object parameter, Map<Object, Object> paramMap) {
        List oredCriteriaList = parameter instanceof Map ? (List)((Map)parameter).get(ORED_CRITERIA) : (List)ReflectUtil.getFieldValue((Object)parameter, (String)ORED_CRITERIA);
        if (CollUtil.isEmpty((Collection)oredCriteriaList)) {
            return;
        }
        Object oredCriteria = oredCriteriaList.get(0);
        List criteriaList = (List)ReflectUtil.getFieldValue(oredCriteria, (String)CRITERIA);
        criteriaList.forEach(criteria -> {
            String condition = (String)ReflectUtil.getFieldValue((Object)criteria, (String)CONDITION);
            columnNameList.stream().forEach(columnName -> {
                Object value = ReflectUtil.getFieldValue((Object)criteria, (String)VALUE);
                if (StrUtil.startWith((CharSequence)condition, (CharSequence)StrUtil.toUnderlineCase((CharSequence)columnName)) && value != null) {
                    if (value instanceof List) {
                        List valueList = (List)value;
                        paramMap.put(columnName, valueList.stream().filter(ObjectUtil::isNotNull).findFirst().get());
                    } else if (value instanceof Number) {
                        paramMap.put(columnName, value);
                    }
                }
            });
        });
    }

    private Long getSysCompanyIdFromObj(Object paramObj) {
        Long sysCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
        if (sysCompanyId == null && paramObj != null) {
            HashMap<Object, Object> paramMap = new HashMap<Object, Object>(16);
            CryptoCardNoPlugin.parseParameter(paramObj, paramMap);
            Object sysCompanyIdObj = paramMap.getOrDefault(SYS_COMPANY_ID, paramMap.get(COMPANY_ID));
            if (sysCompanyIdObj != null) {
                sysCompanyId = Long.valueOf(sysCompanyIdObj.toString());
            } else {
                Long sysBrandId;
                ResponseData brandByID;
                Object sysBrandIdObj = paramMap.getOrDefault(SYS_BRAND_ID, paramMap.get(BRAND_ID));
                if (sysBrandIdObj != null && (brandByID = this.brandServiceRpc.getBrandByID(sysBrandId = Long.valueOf(sysBrandIdObj.toString()))).getCode() == SysResponseEnum.SUCCESS.getCode() && brandByID.getData() != null) {
                    sysCompanyId = ((SysBrandPo)brandByID.getData()).getSysCompanyId();
                }
            }
        }
        if (sysCompanyId != null) {
            CryptoCardNoPlugin.setLocalCompanyId(sysCompanyId);
        }
        return sysCompanyId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseParameter(Object paramObj, Map<Object, Object> map) {
        if (paramObj == null) {
            return;
        }
        if (paramObj instanceof Number || paramObj instanceof Boolean || paramObj instanceof Character) {
            return;
        }
        String className = paramObj.getClass().getName();
        if (paramObj instanceof Map) {
            Map paramMap = (Map)paramObj;
            Set keySet = paramMap.keySet();
            if (keySet.contains(ORED_CRITERIA)) {
                CryptoCardNoPlugin.parseMapForExample(paramObj, map);
            }
            for (Object next : paramMap.keySet()) {
                Object nextValue = paramMap.get(next);
                if (nextValue == null) continue;
                if (nextValue instanceof String || nextValue instanceof Number) {
                    map.put(next, nextValue);
                    continue;
                }
                CryptoCardNoPlugin.parseParameter(nextValue, map);
            }
            return;
        } else if (paramObj instanceof List) {
            Object o;
            List list = (List)paramObj;
            if (!CollUtil.isNotEmpty((Collection)list) || (o = list.get(0)) == null) return;
            CryptoCardNoPlugin.parseParameter(o, map);
            return;
        } else if (CryptoCardNoPlugin.isEndWithExample(className)) {
            CryptoCardNoPlugin.parseMapForExample(paramObj, map);
            return;
        } else {
            try {
                Map stringObjectMap = JacksonUtil.bean2Map((Object)paramObj);
                if (stringObjectMap == null) return;
                map.putAll(stringObjectMap);
                return;
            }
            catch (Exception e) {
                log.info("parseParameter error:{}", (Throwable)e);
            }
        }
    }

    private static boolean isEndWithCount(String methodName) {
        return methodName.endsWith(COUNT_SUFFIX);
    }

    private static boolean isEndWithExample(String className) {
        return className.endsWith(EXAMPLE_SUFFIX);
    }

    private static void setLocalCompanyId(Long sysCompanyId) {
        if (mapThreadLocal.get() == null) {
            mapThreadLocal.set(new HashMap());
        }
        mapThreadLocal.get().put(SYS_COMPANY_ID, sysCompanyId);
    }

    private static void setLocalMethod(Method method) {
        if (mapThreadLocal.get() == null) {
            mapThreadLocal.set(new HashMap());
        }
        if (method != null) {
            mapThreadLocal.get().put(METHOD, method);
        }
    }

    private boolean needEncrypt(Object object) {
        boolean flag = false;
        Long localCompanyId = this.getSysCompanyIdFromObj(object);
        if (localCompanyId != null) {
            List<Long> sysCompanyIdList = encryptPhoneProperties.getSysCompanyIdList();
            flag = CollUtil.contains(sysCompanyIdList, (Object)localCompanyId);
        }
        return flag;
    }

    private static void removeLocalBrandId() {
        Map<String, Object> stringObjectMap = mapThreadLocal.get();
        if (stringObjectMap != null) {
            stringObjectMap.remove(SYS_COMPANY_ID);
            stringObjectMap.remove(METHOD);
        }
    }

    public static Long getLocalCompanyId() {
        Map<String, Object> stringObjectMap = mapThreadLocal.get();
        if (stringObjectMap == null) {
            mapThreadLocal.set(new HashMap());
            return null;
        }
        return (Long)stringObjectMap.get(SYS_COMPANY_ID);
    }

    public static Method getLocalMethod() {
        return (Method)mapThreadLocal.get().get(METHOD);
    }

    public boolean needEncrypt() {
        return this.needEncrypt(null);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        encryptPhoneProperties = (EncryptPhoneProperties)applicationContext.getBean(EncryptPhoneProperties.class);
        this.brandServiceRpc = (BrandServiceRpc)applicationContext.getBean(BrandServiceRpc.class);
        KEY = encryptPhoneProperties.getKey();
        IV = encryptPhoneProperties.getIv();
    }

    static {
        mapThreadLocal = new ThreadLocal();
        KEY = null;
        IV = null;
        columnNameList = Arrays.asList(SYS_COMPANY_ID, COMPANY_ID, SYS_BRAND_ID, BRAND_ID);
    }
}

