package com.bizvane.members.facade.service.third;

import com.bizvane.members.facade.vo.third.ThirdMemberOpenCardReqVo;
import com.bizvane.members.facade.vo.third.ThirdOpenCardResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 第三方调用会员接口
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月28日 09:53:00
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface ThirdMemberApiService {

    /**
     * 第三方开卡接口
     *
     * @param requestVo
     * @return
     */
    @PostMapping(value = "/third/member/openCard")
    ResponseData<ThirdOpenCardResponseVo> openCard(@RequestBody @Valid ThirdMemberOpenCardReqVo requestVo);
}
